-- Unreal Realms - client_profiles (Nekiro-safe) v4
-- Fix: syntax error in previous file, missing json/onError in some forks.
-- This module provides getSettingsFilePath and never crashes.
-- No accents.

-- Provide safe onError if missing
if type(rawget(_G, "onError")) ~= "function" then
  function onError(message)
    local msg = tostring(message or "Unknown error")
    if g_logger and g_logger.error then
      g_logger.error("[Profiles] " .. msg)
    else
      print("[Profiles] " .. msg)
    end
    pcall(function()
      if displayErrorBox then displayErrorBox(tr("Error"), msg) end
    end)
    return false
  end
end

local function sanitizeName(name)
  name = tostring(name or "global")
  name = name:gsub("[^%w%-_]", "_")
  if name == "" then name = "global" end
  return name
end

-- Public API used by other modules
function getSettingsFilePath(fileName)
  local charName = "global"
  pcall(function()
    if g_game and g_game.getCharacterName then
      local n = g_game.getCharacterName()
      if n and n ~= "" then
        charName = n
      end
    end
  end)
  charName = sanitizeName(charName)
  fileName = sanitizeName(fileName)
  -- Flat filename: avoids folder creation issues on butchered builds
  return "profiles_" .. charName .. "_" .. fileName
end

ChangedProfile = false

function init()
  -- Intentionally minimal.
end

function terminate()
  -- Intentionally minimal.
end
